#include <Servo.h>
Servo myservo;
int PWMPin = 5, servoOnPin = 7, servoAnalogInPin = A1,
    posIs, posIsDeg, posDesired, posAmpli = 5, 
    posServo1 = 0, posServo2 = 90, posOffset = 0,
    posSensor1 = 950, posSensor2 = 552; 
const int sampleNumber = 300;
int myRecording[sampleNumber];
int sampleDelay = 30;

void setup(){
  Serial.begin(9600);
  while(!Serial);
  pinMode(servoOnPin, OUTPUT);
  digitalWrite(servoOnPin, HIGH);
}

void loop() {
    Serial.println("Recording starts in 3 seconds");
    delay(3000);
    Serial.println("Recording");
    recordTrajectory();
    Serial.println("Done recording");
    delay(3000);
    Serial.println("Playing");
    replayTrajectory();
    Serial.println("Done replaying");
 }
 
void recordTrajectory() {
  for (int sample=0; sample<sampleNumber; sample++){
     posIs = analogRead(servoAnalogInPin);
     posIsDeg = map(posIs, posSensor1, posSensor2, posServo1, posServo2);
     myRecording[sample] = posIsDeg;
     delay(sampleDelay);
  }
}

void replayTrajectory() {
  myservo.attach(PWMPin);
  for (int sample=0; sample<sampleNumber; sample++){
      posDesired = myRecording[sample];
      posIs = analogRead(servoAnalogInPin);
      posIsDeg = map(posIs, posSensor1, posSensor2, posServo1, posServo2);
      if (abs(posDesired- posIsDeg)>posAmpli){
      myservo.write(abs(posDesired-posOffset)); 
      }
      delay(sampleDelay);
  }
  myservo.detach();
}
