using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using System.IO.Ports;
using System.IO;
using System;

public class BarControl : MonoBehaviour{
    SerialPort sp;
    void Start() {
        sp = new SerialPort("COM3", 19200);
        sp.ReadTimeout = 5;
        sp.WriteTimeout = 5;
        sp.Open();
    }
    void Update() {
        if (sp.IsOpen) {
            try {
                int positionSensorValue = sp.ReadByte();
                float positionUnity = (10 - ((float)positionSensorValue / 10));
                transform.position = new Vector3(positionUnity, transform.position.y, transform.position.z);
                sp.DiscardInBuffer();
            }
            catch (System.Exception e) {
            }
            try {
                float positionDifference = transform.position.x - GameObject.Find("Ball").transform.position.x;

                if (positionDifference < -3){
                    sp.WriteLine("L");
                }
                else if (positionDifference > 3)  {
                    sp.WriteLine("R");
                }
                else {
                    sp.WriteLine("O");
                }
            }
            catch (System.Exception e) {
            }
        }
    }
}
