#include <Servo.h>
Servo myservo;
const int servoOnPin = 7, PWMPin = 5, servoAnalogInPin = A1;
int posIs,
    posServo1 = 0, posServo2 = 100, 
    posSensor1 = 950, posSensor2 = 510, 
    posDesired1 = 5, posDesired2 = 90, posOffset = 0;
byte sendValue;
char unityCommand;

void setup() {
  Serial.begin(19200);
  pinMode(servoOnPin, OUTPUT);
  digitalWrite(servoOnPin, HIGH);
 }

void loop() {
  if (Serial.available() > 0){
    posIs = analogRead(servoAnalogInPin);
    sendValue = map(posIs, posSensor1, posSensor2, posServo1, posServo2);
    Serial.write(sendValue);
    Serial.flush();
    delay(100);
  
    unityCommand = Serial.read();
    switch(unityCommand) {
      case 'O':{
        if(myservo.attached()) 
         myservo.detach();
      }
      break;
      case 'L':{
        if(!myservo.attached()) 
          myservo.attach(PWMPin);
          myservo.write(abs(posDesired1-posOffset));    
        }
      break;
      case 'R':{
        if(!myservo.attached()) 
          myservo.attach(PWMPin);
          myservo.write(abs(posDesired2-posOffset));  
        }
      break;
     }
    while(Serial.available() > 0) {
      Serial.read();
    }
  }
} 
