#include <Servo.h>
Servo myservo;  
const int buttonPin1 = 3, buttonPin2 = 2,
          servoOnPin = 7, PWMPin = 5;    
int buttonState1, buttonState2,   
    minAngle = 0, maxAngle = 90,
    pos, posOffset = 0;
    
void setup() {
  pinMode(buttonPin1, INPUT_PULLUP);
  pinMode(buttonPin2, INPUT_PULLUP);
  pinMode(servoOnPin, OUTPUT);
  digitalWrite(servoOnPin, HIGH);
}

void loop() {
  buttonState1 = digitalRead(buttonPin1);
  buttonState2 = digitalRead(buttonPin2);

  if (buttonState1 == LOW){
    myservo.detach();
  }
    
  if (buttonState2 == LOW){
    myservo.attach(PWMPin);
  }

  for (pos = minAngle; pos <= maxAngle; pos +=1){
    myservo.write(abs(pos-posOffset));       
    delay(30);                   
  }
  delay(30);

  for (pos = maxAngle; pos >= minAngle; pos -=1){ 
    myservo.write(abs(pos-posOffset));             
    delay(30);                   
  }
  delay(30);
}
