#include <Servo.h>
Servo myservo;  
const int buttonPin1 = 3, buttonPin2 = 2,
          servoOnPin = 7, PWMPin = 5;    
int buttonState1, buttonState2,   
    minAngle = 0, maxAngle = 90,
    pos, posOffset = 0;

void setup() {
  pinMode(servoOnPin, OUTPUT);
  digitalWrite(servoOnPin, HIGH);
  pinMode(buttonPin1, INPUT_PULLUP);
  pinMode(buttonPin2, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(buttonPin1), detach, FALLING);
  attachInterrupt(digitalPinToInterrupt(buttonPin2), attach, FALLING);
}

void loop() {
  for (pos = minAngle; pos <= maxAngle; pos +=1){
    myservo.write(abs(pos-posOffset));       
    delay(30);                   
  }
  delay(300);
  for (pos = maxAngle; pos >= minAngle; pos -=1){ 
    myservo.write(abs(pos-posOffset));             
    delay(30);                   
  }
  delay(300);
}

void attach() {
  myservo.attach(PWMPin);
}

void detach() {
  myservo.detach();
}