#include <Arduino_LSM6DS3.h>
int startTime, calibrationCount = 0, calibrationMillis = 1000;
float gyroX,             gyroY,              gyroZ,             
      gyroDriftX,        gyroDriftY,         gyroDriftZ,
      sumX,              sumY,               sumZ;

void setup() {
  Serial.begin(9600);
  while (!Serial);
  IMU.begin();
  startTime = millis();
  while (millis() < startTime + calibrationMillis) {
    IMU.readGyroscope(gyroX, gyroY, gyroZ);
      sumX += gyroX;
      sumY += gyroY;
      sumZ += gyroZ;
      calibrationCount++;
  }
  gyroDriftX = sumX / calibrationCount;
  gyroDriftY = sumY / calibrationCount;
  gyroDriftZ = sumZ / calibrationCount;
}

void loop() {
IMU.readGyroscope(gyroX, gyroY, gyroZ);
gyroX = gyroX - gyroDriftX;
gyroY = gyroY - gyroDriftY;
gyroZ = gyroZ - gyroDriftZ;
Serial.print("gyroX:");
Serial.print(gyroX);
Serial.print("\t");
Serial.print("gyroY:");
Serial.print(gyroY);
Serial.print("\t");
Serial.print("gyroZ:");
Serial.println(gyroZ);
delay(100);  
}