#include <Servo.h>
Servo myservo;  
const int servoOnPin = 7, PWMPin = 5,  
          forceAnalogInPin = A2, ampliSwitchPin = 8, gainSelectPin = 4, 
          buttonPin1 = 3, buttonPin2 = 2;     
int positionDesired,
    minAngle = 5, maxAngle = 90, posOffset = 0,
    forceOffset = 520, forceDesired = 0, forceThreshold = 20,
    delayTime = 50;
float forceIs, gain = 0.1;

void setup(){
  Serial.begin(9600);
  while(!Serial);
  pinMode(buttonPin1, INPUT_PULLUP);
  pinMode(buttonPin2, INPUT_PULLUP);
  attachInterrupt(digitalPinToInterrupt(buttonPin1), PowerDown, FALLING);
  attachInterrupt(digitalPinToInterrupt(buttonPin2), PowerUp, FALLING);
  pinMode(gainSelectPin, OUTPUT);
  digitalWrite(gainSelectPin, LOW);
  pinMode(ampliSwitchPin, OUTPUT);
  digitalWrite(ampliSwitchPin, HIGH);
  pinMode(servoOnPin, OUTPUT);
  digitalWrite(servoOnPin, LOW);
 }

 void loop(){
  forceIs = analogRead(forceAnalogInPin)-forceOffset;
  if (abs(forceIs-forceDesired)>forceThreshold){ 
  positionDesired += gain*(forceIs-forceDesired);
  }
  if (positionDesired < minAngle){
  positionDesired = minAngle;
  }
  else if (positionDesired > maxAngle){
  positionDesired = maxAngle;
  }
  myservo.attach(PWMPin);
  myservo.write(abs(positionDesired-posOffset));
  delay(delayTime);
  
  Serial.print("forceDesired:");
  Serial.print(forceDesired);
  Serial.print(",");
  Serial.print("positionDesired:");
  Serial.print(positionDesired);
  Serial.print(",");
  Serial.print("forceIs:");
  Serial.println(forceIs);
 }

void PowerUp() {
  digitalWrite(servoOnPin, HIGH);
}
void PowerDown() {
  digitalWrite(servoOnPin, LOW);
}