using UnityEngine;
using System.Collections;
using System.Collections.Generic;
using System.IO.Ports;
using System.IO;
using System;

public class BarControl : MonoBehaviour {
    SerialPort sp;

    void Start() {
        sp = new SerialPort("COM6", 9600);
        sp.ReadTimeout = 10;
        sp.Open();
    }

    void Update() {
        if (sp.IsOpen) {
            try {
                int value = sp.ReadByte();
                float positionUnity = (10 - ((float)value / 10));
                transform.position = new Vector3(positionUnity, transform.position.y, transform.position.z); 
            }
            catch (System.Exception e) {
            }
        }
    }
}
